/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.ProgressActionHandler;
import com.ibm.hwmca.fw.task.ProgressBean;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.ui.framework.UserTaskManager;
import java.util.TimerTask;

class ProgressTimerTask
extends TimerTask
implements TaskErrorIds {
    private UserTaskManager utm;
    private boolean alreadyLogged = false;
    private boolean mode = false;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "ProgTimerTsk");

    ProgressTimerTask(UserTaskManager utm) {
        this.utm = utm;
    }

    UserTaskManager getUserTaskManager() {
        return this.utm;
    }

    void setMode(boolean mode) {
        this.mode = mode;
    }

    boolean getMode() {
        return this.mode;
    }

    public void run() {
        block6: {
            try {
                if (this.mode) {
                    ProgressBean bean = (ProgressBean)this.utm.getDataObjects()[0];
                    ProgressStartEvent start = bean.getStartEvent();
                    ProgressEndedListener callback = start.getProgressEndedListener();
                    if (callback != null) {
                        ProgressActionHandler.callListener(null, callback, start.getId());
                    }
                    this.utm.dispose();
                } else {
                    ProgressBean bean = (ProgressBean)this.utm.getDataObjects()[0];
                    bean.setElapsed();
                    if (!CommonSystem.getCommonSystem().isUsingHTML()) {
                        this.utm.refreshElement("ElapsedTimeOutput");
                    }
                }
            }
            catch (Exception e) {
                if (this.alreadyLogged) break block6;
                HException ex = new HException(e);
                new FrameworkLog(classLogInfo, 51, ex).log();
                this.alreadyLogged = true;
            }
        }
    }
}

